<?php
// file: api/set_exchange.php
require_once "../config.php";

header('Content-Type: application/json');

// Enable error logging
error_log("=== set_exchange.php called ===");
error_log("REQUEST_METHOD: " . $_SERVER['REQUEST_METHOD']);
error_log("POST data: " . print_r($_POST, true));

// 1) Only POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    error_log("ERROR: Invalid request method - " . $_SERVER['REQUEST_METHOD']);
    echo json_encode(['error' => 'Invalid request method']);
    exit;
}

// Read data from both POST and JSON body
$data = $_POST;
if (empty($data)) {
    $raw = file_get_contents("php://input");
    if (!empty($raw)) {
        $json = json_decode($raw, true);
        if (is_array($json)) {
            $data = $json;
        }
    }
}

error_log("Parsed data: " . print_r($data, true));

// 2) Check API secret
$client_secret = $data['api_secret'] ?? '';
if ($client_secret !== API_SECRET) {
    http_response_code(401);
    error_log("ERROR: Unauthorized - secret mismatch");
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// 3) Read and validate rate
$rate_raw = $data['exchange_rate'] ?? '';
$rate = floatval($rate_raw);

error_log("Exchange rate received: " . $rate);

if ($rate <= 0) {
    http_response_code(400);
    error_log("ERROR: Invalid exchange rate - " . $rate_raw);
    echo json_encode(['error' => 'Invalid exchange rate']);
    exit;
}

// 4) Save into settings table (id=1 row)
$stmt = $conn->prepare("
    INSERT INTO settings (id, exchange_rate)
    VALUES (1, ?)
    ON DUPLICATE KEY UPDATE exchange_rate = VALUES(exchange_rate)
");
$stmt->bind_param("d", $rate);

if ($stmt->execute()) {
    error_log("SUCCESS: Exchange rate updated to " . $rate);
    echo json_encode([
        'status' => 'success',
        'exchange_rate' => $rate
    ]);
} else {
    http_response_code(500);
    error_log("ERROR: DB error - " . $stmt->error);
    echo json_encode(['error' => 'DB error: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
